#include "Person.h"

//Default Constructor
Person::Person()
{

}

//Constructor for two strings
Person::Person(const string& person_Name, const string& person_Birthday)
{
	setName(person_Name);
	setBirthday(person_Birthday);
}


//Destructor
Person::~Person()
{
	name = "\0";
	birthdate = "\0";
}

/***************************** SETTERS *******************************************/
//Sets the name from a string
//Returns false if the parsed name is invalid
//Returns true otherwise
//Sets Name

void Person::setName(const string &newName)
{
	string parsedName = parse(newName);
	name = "";

	for (int i = 0; i < (int)parsedName.length(); i++) {
		if (isalpha(parsedName[i]))
			name += toupper(parsedName[i]);
		else
			name += parsedName[i];
	}
}

//Sets the Birthday from a string
void Person::setBirthday(const string& newBirthdate)
{
	birthdate = "";
	string parsedBirthdate = parse(newBirthdate);
	for (int i = 0; i < (int)parsedBirthdate.length(); i++) {
		if (parsedBirthdate[i] == ':' || parsedBirthdate[i] == ';')
			birthdate += parsedBirthdate[i];
		else if (isalpha(parsedBirthdate[i]))
			birthdate += toupper(parsedBirthdate[i]);
		else
			birthdate += parsedBirthdate[i];
	}

}
/**************************** PRIVATE FUNCTIONS ******************************************/
//Parses a string
const string Person::parse(const string& input) const
{
	int frontSpaces = 0;
	int backSpaces = 0;
	for (int i = 0; i < (int)input.length() && (input[i] == ' ' || input[i] == '\t' || input[i] == '\n'); i++)
	{
		frontSpaces++;
	}
	for (int i = (int)input.length() - 1; i >= 0 && (input[i] == ' ' || input[i] == '\t' || input[i] == '\n'); i++) {
		backSpaces++;
	}
	backSpaces = (int)input.length() - backSpaces;

	string parsed = "";
	for (int i = frontSpaces; i < backSpaces; i++)
		parsed += input[i];

	return parsed;
}

/**************************** OVERLOADED OPERATORS ******************************************/

//Writes the Person values to ostream parameter and returns it

ostream& operator <<(ostream &os, const Person &person)
{
	string halfName1 = person.name;
	string halfBday1 = person.birthdate;

	os << person.name << " " << person.birthdate<<endl;
	return os;
}

//For sorting
bool Person::operator >(const Person &person) const {
	if (name > person.name)
		return true;

	return false;
}

//For sorting
bool Person::operator <(const Person &person) const {
	if (name < person.name)
		return true;

	return false;
}

//For sorting
bool Person::operator ==(const Person &person) const {
	if (name == person.name)
		return true;

	return false;
}

//For sorting
bool Person::operator !=(const Person &person) const {
	if (name != person.name)
		return true;

	return false;
}

//For Searching
bool Person::operator ==(const string& searchName) const {
	if (name == searchName)
		return true;

	return false;
}

//For Searching
bool Person::operator !=(const string& searchName) const {
	if (name != searchName)
		return true;

	return false;
}
